#!/usr/bin/perl
# Generate Vitess Makefile for both Unix gmake and Windows nmake
#
# Change $mscdir and $sroot to your needs.
#
# calls
# mmake.pl             to print Windows nmake file to stdout
# mmake.pl u           to print Unix gmake makefile to stdout

use strict;

my $unixout = $ARGV[0] =~ /u/i;

### configure here ####################################################
###

# my $mscdir = 'D:|programme|microsoft visual studio|vc98';
my $mscdir = 'c:|programme|microsoft visual studio .net 2003|vc7';
#my $spath = 'e:|control|vitess|SRC';
my $sroot = 'h:|control';
my $svnroot = 'h:|control|vitess|trunk';

my $unixcomment =<<'EOS';
#
# compile hosts to use
# Linux : dixi3
# SunOS : dsapp3
# OSF1  : darling

EOS

###
### end configure ######################################################

### define targets #####################################################
###
# tool objects
my @Obj = qw(init general intersection matrix sample);

# modules which need TOOL (init general)
my @C = qw(ascii2bin eval_elast monitor1
	   mon2_div mon2_pos mon2_posdiv mon2_tofwl mon2_wldiv
	   velselect writeout gener_batch lattice_dist
	   mirror_coating surface_file guide_shape);

# modules which need ITOOL (=TOOL + intersection)
my @CI = qw(chopper_disc chopper_fermi collimator_soller
	    source spacewindow spacewindow_multiple space);

# modules which need MTOOL (=ITOOL + matrix)
my @CM = qw(detector eval_inelast frame guide
	    monitorpol_1d monitorpol_pos
	    monochr_analyser
	    polariser_sm polariser_he3 flipper_coil
	    pol_mirror
	    precessionfield
	    rotating_field flipper_gradient resonator_drabkin
	    sample_elasticisotr sample_inelast
	    sample_reflectom
	    define_direction
	    sample_singcryst
	    cas_v40
	   );

# modules which need STOOL (=MTOOL + sample)
my @CS = qw(sample_powder sample_s_q sample_sans);

my @Gexe = qw(bender visual sm_ensemble dist_time);

# auxillary programs without further libs
my @PTool = qw(chop_phases standard_deviation direct_view);

my %Macro;
$Macro{$_} = '$(TOOL)' foreach ('visual', 'dist_time', @C);
$Macro{$_} = '$(ITOOL)' foreach ('bender', @CI);
$Macro{$_} = '$(MTOOL)' foreach ('sm_ensemble', @CM);
$Macro{$_} = '$(STOOL)' foreach @CS;

my %dep = (			# needed objects for a module
	   source => 'src_modchar',
	   sample_s_q => 'sq_calc',
	   monochr_analyser => 'ma_functions ma_geom',
	   precessionfield => 'magneticmap',
	   gener_batch => 'gener_fct',
	   spacewindow => 'bender_inter_data',
	   spacewindow_multiple => 'bender_inter_data',
	   chopper_disc => 'bender_inter_data');

# objects necessary for some modules, to be compiled separately
my %K;
foreach (keys %dep) {
  foreach (split(' ', $dep{$_})) {
    $K{$_} = 1;
  }
}
push @Obj, keys(%K);

$dep{bender} = $_ = 'bendtest bendchtr bendertr bender_inter_data cpgplot';
# objects which have to be compiled with special options
my @Gobj;
foreach (split) {
  push @Gobj, $_ unless $K{$_};
}

$dep{$_} = 'cpgplot' foreach qw(visual dist_time sm_ensemble);

my (%sopt, %lib);
foreach (qw(visual bender dist_time sm_ensemble)) {
  $sopt{$_} = '$(GRAOPT)';		# special compile options for a module
  $lib{$_} = '$(GRALIB)';		# needed libs for a module
}

my @All = (@C, @CI, @CM, @CS, @Gexe, @PTool);

###
### end define targets #####################################################################

if ($unixout) {

  my $pwd = $ENV{PWD};
  $_ = join(" \\\n", @All);
  print <<EOS;
# Unix gmake Makefile for VITESS modules
# generated by
# mmake.pl u
#
$unixcomment
INSTDIR = ../MODULES/

ALL = $_
EOS

  print <<'EOS';

TOOL = init.o general.o message.o
ITOOL = intersection.o $(TOOL)
MTOOL = matrix.o $(ITOOL)
STOOL = sample.o $(MTOOL)

SYS = $(shell uname)
CFLAGS = -O3 -fomit-frame-pointer -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64

GRAOPT = -DDO_X11 -DDO_GIF -DVT_GRAPH -I.
ifeq ($(SYS),SunOS)
CCOMP = /net/bin/gcc
CC = $(CCOMP) $(CFLAGS)
GRALIB = $(GRAOPT) -Ig2/SunOS  -Lg2/SunOS -lg2 -L/net/usr/lib -L/usr/openwin/lib -R/usr/openwin/lib -L/usr/local/libll -lm -lX11 -lgd -lpng
endif

ifeq ($(SYS),OSF1)
CCOMP = /net/bin/gcc
CC = $(CCOMP) -DOSF $(CFLAGS)
GRALIB = $(GRAOPT) -Ig2/OSF1 -Lg2/OSF1  -L/net/usr/lib -lg2 -lX11 -lm -lgd -lpng
endif

ifeq ($(SYS),Linux)
CCOMP = gcc
CC = $(CCOMP) $(CFLAGS)
GRALIB = $(GRAOPT) -Ig2/Linux -Lg2/Linux -L/usr/X11R6/lib -L/usr/local/lib -lX11 -lg2 -lgd -lpng -lz -lfreetype -lXpm -lttf -lm
endif

LIBS = -lm

.KEEP_STATE :

all: $(ALL)
	strip $^
EOS

  $dep{$_} = "$_ $dep{$_}" foreach @All;	

  foreach my $d (keys %dep) {
    my $l = $lib{$d} || '$(LIBS)';
    print $d . ' : ' .  join('.c ', split(' ', $dep{$d})) . '.c ' . $Macro{$d} .
      "\n\t" . '$(CC) -o $@ $^ ' . "$l\n\n";
  }
	
  print <<'EOS';
Move:
	a=_$(SYS) ; h=$(INSTDIR) ; for l in $(ALL) ; do mv $$l $$h$$l$$a ; done
	rm *.o
Copy:
	a=_$(SYS) ; h=$(INSTDIR) ; for l in $(ALL) ; do cp $$l $$h$$l$$a ; done

clean :
	rm *.o $(ALL)
EOS

  exit;
}


my $s = <<EOS;
# Vitess NMAKE File
CPATH=$mscdir
SROOT=$sroot
SVNROOT=$svnroot
EOS

$s .= <<'EOS';
CPATH2=$(CPATH)|PlatformSDK
IPATH=$(CPATH)|include
LPATH=$(CPATH)|lib
IPATH2=$(CPATH2)|include
LPATH2=$(CPATH2)|lib

SPATH=$(SVNROOT)|SRC
GPATH=$(SROOT)|g2_win

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE
NULL=nul
!ENDIF

OD=.|Release
IDIR=.|Release

CPP=cl.exe
DEFS=/DNDEBUG /DDO_WIN32 /DCONSOLE /DWIN32 /D "_MBCS"
INC=/I "$(IPATH)" /I "$(IPATH2)" /I "$(SPATH)"
CPP_OPT=/nologo /ML /W3 /Ox $(INC) $(DEFS) /Fp"$(IDIR)|vit.pch" /YX /FD /c
CPP_PROJ=$(CPP_OPT) /Fo"$(IDIR)||" /Fd"$(IDIR)||"
GRAOPT=/I "$(GPATH)" /I "$(GPATH)\WIN32" /I "$(GPATH)\PS" /DDO_PS /DVT_GRAPH

LINK32=link.exe
WINLIBS=kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib |
 shell32.lib
LINK32_FLAGS=/nologo /subsystem:console /incremental:no /machine:I386 /opt:ref /opt:icf,5 |
 /libpath:"$(LPATH)" /libpath:"$(LPATH2)" /libpath:"$(GPATH)"
TOOL="$(IDIR)|init.obj" "$(IDIR)|general.obj" "$(IDIR)|message.obj"
ITOOL="$(IDIR)|intersection.obj" $(TOOL)
MTOOL="$(IDIR)|matrix.obj" $(ITOOL)
STOOL="$(IDIR)|sample.obj" $(MTOOL)
GRALIB=g2.lib
ML=$(WINLIBS) $(LINK32_FLAGS)

.c{$(IDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

"$(OD)" :
    if not exist "$(OD)|$(NULL)" mkdir "$(OD)"

EOS

$s .= 'ALL :';
foreach (@All) {
  $s .= " |\n\t" . '"$(OD)|' . $_ . '.exe"';
}

$s .= "\n\n";

my $rulestart = "SOURCE=\$(SPATH)|xxx.c\n" . <<'EOS';
"$(IDIR)|xxx.obj" : $(SOURCE)
	$(CPP) $(CPP_PROJ) $(SOURCE)

EOS

# Objects
my $rule = $rulestart;
subRule($rule, @Obj);

# Tool, @C
$rule .=  <<'EOS';
"$(OD)|xxx.exe" : "$(OD)" $(TOOL) "$(OD)|xxx.obj" yyy
	$(LINK32) $(ML) /pdb:"$(OD)|xxx.pdb" /out:"$(OD)|xxx.exe" "$(IDIR)|xxx.obj" $(TOOL) yyy zzz

EOS
subRule($rule, @C);

# ITool, @CI
$rule =~ s/TOOL/ITOOL/g;
subRule($rule, @CI);

# MTool, @CM
$rule =~ s/ITOOL/MTOOL/g;
subRule($rule, @CM);

# STool, @CS
$rule =~ s/MTOOL/STOOL/g;
subRule($rule, @CS);

# PTool
$rule = $rulestart . <<'EOS';
"$(OD)|xxx.exe" : "$(OD)" "$(OD)|xxx.obj" yyy
	$(LINK32) $(ML) /pdb:"$(OD)|xxx.pdb" /out:"$(OD)|xxx.exe" "$(IDIR)|xxx.obj" yyy

EOS
subRule($rule, @PTool);

# Gobj
$rule = 'SOURCE=$(SPATH)|xxx.c' . "\n" . <<'EOS';
"$(IDIR)|xxx.obj" : $(SOURCE)
	$(CPP) $(GRAOPT) $(CPP_PROJ) $(SOURCE)

EOS
subRule($rule, @Gobj);

$rule .= <<'EOS';
"$(OD)|xxx.exe" : "$(OD)" "$(OD)|xxx.obj" $(MTOOL) yyy
	$(LINK32) $(ML) $(MTOOL) $(GRALIB) /pdb:"$(OD)|xxx.pdb" /out:"$(OD)|xxx.exe" "$(IDIR)|xxx.obj" yyy

EOS
subRule($rule, @Gexe);


foreach (split "\n", $s) {
  s/ +/ /;
  s/ $//;
  tr/|/\\/;
  print "$_
\n";
}


sub subRule {
# substitute names in rules
# xxx  module name
# ooo  special cc options
# yyy  objects to link with
# zzz  libraries to link with

  my $rule = shift;
  foreach my $c (@_) {
    $_ = $rule;
    s/xxx/$c/g;
    my $d = $dep{$c};
    if ($d eq '') {
      s/yyy//g;
    } else {
      my $rep;
      foreach my $m (split ' ',$d) {
	$rep .= '"$(OD)|' . $m . '.obj" ';
      }
      s/yyy/$rep/g;
    }
    s/zzz/$lib{$c}/;
    s/ooo/$sopt{$c}/;
    $s .= $_;
  }
}
